/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.model.resource;

import java.io.File;
import rpgboss.lib.Utils$;
import rpgboss.model.Project;
import rpgboss.model.RpgMapData;
import rpgboss.model.resource.MetaResource;
import rpgboss.model.resource.MetaResource$class;
import rpgboss.model.resource.RpgMap;
import rpgboss.model.resource.RpgMapMetadata;
import rpgboss.model.resource.RpgMapMetadata$;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.ScalaRunTime$;

public final class RpgMap$
implements MetaResource<RpgMap, RpgMapMetadata>,
Serializable {
    public static final RpgMap$ MODULE$;
    private final int minXSize;
    private final int minYSize;
    private final int maxXSize;
    private final int maxYSize;
    private final int initXSize;
    private final int initYSize;
    private final int bytesPerTile;
    private final byte autotileByte;
    private final byte emptyTileByte;

    static {
        new RpgMap$();
    }

    @Override
    public File rcDir(Project proj) {
        return MetaResource$class.rcDir(this, proj);
    }

    @Override
    public boolean extensionFilter(File file) {
        return MetaResource$class.extensionFilter(this, file);
    }

    @Override
    public String[] listSystemResources() {
        return MetaResource$class.listSystemResources(this);
    }

    @Override
    public String[] listCustomResources(Project proj) {
        return MetaResource$class.listCustomResources(this, proj);
    }

    @Override
    public String[] list(Project proj) {
        return MetaResource$class.list(this, proj);
    }

    @Override
    public String[] listResourcesUnderPath(Project project, String folderPath) {
        return MetaResource$class.listResourcesUnderPath(this, project, folderPath);
    }

    @Override
    public void importCustom(Project proj, File source) {
        MetaResource$class.importCustom(this, proj, source);
    }

    @Override
    public boolean deleteCustom(Project proj, String name) {
        return MetaResource$class.deleteCustom(this, proj, name);
    }

    @Override
    public String metadataPathRelative(String name) {
        return MetaResource$class.metadataPathRelative(this, name);
    }

    @Override
    public File metadataPath(Project proj, String name) {
        return MetaResource$class.metadataPath(this, proj, name);
    }

    @Override
    public Object readFromDisk(Project proj, String name, Manifest m) {
        return MetaResource$class.readFromDisk(this, proj, name, m);
    }

    @Override
    public String rcType() {
        return "rpgmap";
    }

    public String mapExt() {
        return "rpgmap";
    }

    @Override
    public String[] keyExts() {
        return (String[])((Object[])new String[]{this.mapExt()});
    }

    public int minXSize() {
        return this.minXSize;
    }

    public int minYSize() {
        return this.minYSize;
    }

    public int maxXSize() {
        return this.maxXSize;
    }

    public int maxYSize() {
        return this.maxYSize;
    }

    public int initXSize() {
        return this.initXSize;
    }

    public int initYSize() {
        return this.initYSize;
    }

    public int bytesPerTile() {
        return this.bytesPerTile;
    }

    public byte autotileByte() {
        return this.autotileByte;
    }

    public byte emptyTileByte() {
        return this.emptyTileByte;
    }

    public byte[] autotileSeed() {
        return (byte[])Array$.MODULE$.apply(Predef$.MODULE$.wrapByteArray(new byte[]{this.autotileByte(), 0, 0}), ClassTag$.MODULE$.Byte());
    }

    public byte[] emptyTileSeed() {
        return (byte[])Array$.MODULE$.apply(Predef$.MODULE$.wrapByteArray(new byte[]{this.emptyTileByte(), 0, 0}), ClassTag$.MODULE$.Byte());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] makeRowArray(int nTiles, byte[] seed) {
        void var3_3;
        Predef$.MODULE$.assert(seed.length == this.bytesPerTile());
        byte[] newArray = (byte[])Array$.MODULE$.tabulate(nTiles * this.bytesPerTile(), new Serializable(seed){
            private final byte[] seed$1;

            public final byte apply(int i) {
                return this.seed$1[i % RpgMap$.MODULE$.bytesPerTile()];
            }
            {
                this.seed$1 = seed$1;
            }
        }, ClassTag$.MODULE$.Byte());
        Predef$.MODULE$.assert(newArray.length == nTiles * this.bytesPerTile());
        return var3_3;
    }

    public String generateName(int id) {
        return Utils$.MODULE$.generateFilename("Map", id, this.mapExt());
    }

    @Override
    public RpgMap defaultInstance(Project proj, String name) {
        int idxOfDot = name.indexOf(".");
        String title = idxOfDot > 0 ? name.substring(0, idxOfDot) : name;
        RpgMapMetadata m = new RpgMapMetadata("", title, this.initXSize(), this.initYSize(), RpgMapMetadata$.MODULE$.apply$default$5(), RpgMapMetadata$.MODULE$.apply$default$6(), RpgMapMetadata$.MODULE$.apply$default$7(), RpgMapMetadata$.MODULE$.apply$default$8(), RpgMapMetadata$.MODULE$.apply$default$9(), RpgMapMetadata$.MODULE$.apply$default$10(), RpgMapMetadata$.MODULE$.apply$default$11(), RpgMapMetadata$.MODULE$.apply$default$12(), RpgMapMetadata$.MODULE$.apply$default$13(), RpgMapMetadata$.MODULE$.apply$default$14());
        return new RpgMap(proj, name, m);
    }

    public RpgMapData emptyMapData(int xSize, int ySize) {
        return new RpgMapData(this.autoLayer$1(xSize, ySize), this.emptyLayer$1(xSize, ySize), this.emptyLayer$1(xSize, ySize), (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$));
    }

    public RpgMapData defaultMapData() {
        return this.emptyMapData(this.initXSize(), this.initYSize());
    }

    @Override
    public RpgMap apply(Project proj, String name, RpgMapMetadata metadata) {
        return new RpgMap(proj, name, metadata);
    }

    public Option<Tuple3<Project, String, RpgMapMetadata>> unapply(RpgMap x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Project, String, RpgMapMetadata>>(new Tuple3<Project, String, RpgMapMetadata>(x$0.proj(), x$0.name(), x$0.metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final byte[][] autoLayer$1(int xSize$1, int ySize$1) {
        byte[] row = this.makeRowArray(xSize$1, this.autotileSeed());
        return (byte[][])Array$.MODULE$.fill(ySize$1, new Serializable(row){
            private final byte[] row$1;

            public final byte[] apply() {
                return (byte[])this.row$1.clone();
            }
            {
                this.row$1 = row$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private final byte[][] emptyLayer$1(int xSize$1, int ySize$1) {
        byte[] row = this.makeRowArray(xSize$1, this.emptyTileSeed());
        return (byte[][])Array$.MODULE$.fill(ySize$1, new Serializable(row){
            private final byte[] row$2;

            public final byte[] apply() {
                return (byte[])this.row$2.clone();
            }
            {
                this.row$2 = row$2;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private RpgMap$() {
        MODULE$ = this;
        MetaResource$class.$init$(this);
        this.minXSize = 20;
        this.minYSize = 15;
        this.maxXSize = 500;
        this.maxYSize = 500;
        this.initXSize = 40;
        this.initYSize = 30;
        this.bytesPerTile = 3;
        this.autotileByte = (byte)-2;
        this.emptyTileByte = (byte)-1;
    }
}

